from kmeans_pytorch import Kmeans_torch
from sklearn.cluster import KMeans
import torch
import util
import numpy as np
import cProfile
from sklearn import datasets
import time

def test_convergence():
    points = torch.Tensor([[0,1], [100,2], [1,1]])
    normalized_points = points/np.max(np.linalg.norm(points, axis=1))
    alg = Kmeans_torch(2,2,1)
    alg.fit(normalized_points)
    print(alg.centers)

def test_convergence_all():
    data =torch.from_numpy(datasets.fetch_covtype().data)
    data = data.to(torch.double)
    subset_data = data[torch.randperm(data.shape[0])[:100000]]
    normalized_data = subset_data/np.max(np.linalg.norm(subset_data, axis=1))
    alg = Kmeans_torch(2,2,1)
    alg.fit(normalized_data)
    print(alg.history)
    print(alg.centers)

# test_convergence_all()

def test_kmeans2_torch():
    start_time = time.time()
    data =torch.from_numpy(datasets.fetch_covtype().data)
    data = data.to(torch.double)
    subset_data = data[torch.randperm(data.shape[0])[:-1]]
    normalized_data = subset_data/np.max(np.linalg.norm(subset_data, axis=1))
    
    alg = Kmeans_torch(2,2, 1, lr=0.1)
    alg.fit_2(normalized_data, 10, 100) #,initial_centers=kmeans.cluster_centers_)
    print(alg.history)
    print(alg.centers)
    print("time: ", time.time() - start_time)
    
    # kmeans = KMeans(2,init="random", n_init=1, max_iter=10)
    # kmeans.fit(normalized_data)
    # print("kmeans: ", kmeans.inertia_)
    # print("kmeans centers: ", kmeans.cluster_centers_)

def test_kmeans_fit2():
    points = torch.Tensor([[0,1], [100,2], [50,52], [1,1]])
    normalized_points = points/np.max(np.linalg.norm(points, axis=1))
    alg = Kmeans_torch(2,2, 1)
    alg.fit_2(normalized_points, 10, 100)
    print(alg.centers)
